/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./plg_system_extrapro/es6/util/ajax.es6":
/*!***********************************************!*\
  !*** ./plg_system_extrapro/es6/util/ajax.es6 ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * @package     ExtraPro Plugin
 * @subpackage  plg_system_extrapro
 * @version     1.0.0
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var ExtraProAjax = /*#__PURE__*/function () {
  function ExtraProAjax() {
    _classCallCheck(this, ExtraProAjax);
    this.options = null;
    this.controller = null;
  }
  _createClass(ExtraProAjax, [{
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "sendAjax",
    value: function sendAjax() {
      var _this = this;
      var action = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return new Promise(function (success, error) {
        if (action === null) {
          return error({
            message: 'Action is empty'
          });
        }
        var controller = _this.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var isFormData = data instanceof FormData,
          formData = isFormData ? data : new FormData();
        if (!isFormData) {
          formData = _this.objectToFormData(data, formData);
        }
        formData.set('action', action);
        _this.sendRequest(controller, formData).then(function (s) {
          return success(s);
        }).catch(function (e) {
          return error(e);
        });
      });
    }
  }, {
    key: "objectToFormData",
    value: function objectToFormData() {
      var _this2 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (formData === null) {
        formData = new FormData();
      }
      if (path === null) {
        path = '';
      }
      Object.keys(data).forEach(function (key) {
        var name = path ? path + '[' + key + ']' : key,
          value = data[key];
        if (Array.isArray(value)) {
          value.forEach(function (val) {
            formData.append(name + '[]', val);
          });
        } else if (_typeof(value) === 'object') {
          formData = _this2.objectToFormData(value, formData, name);
        } else {
          formData.set(name, value);
        }
      });
      return formData;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(controller, formData) {
      var _this3 = this;
      return new Promise(function (success, error) {
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            var errorObject = _this3.parseJoomlaRequestError(e);
            if (errorObject) {
              return error(errorObject);
            }
          }
        });
      });
    }
  }, {
    key: "parseJoomlaRequestError",
    value: function parseJoomlaRequestError(error) {
      if (error instanceof XMLHttpRequest) {
        if (error.status === 0) {
          console.error('aborted');
          return false;
        }
        var message;
        if (error.response) {
          var responseElement = document.createElement('div');
          responseElement.innerHTML = error.response;
          if (responseElement) {
            responseElement = responseElement.querySelector('title');
            if (responseElement) {
              message = responseElement.textContent;
            }
          }
        } else {
          message = error.status + ' ' + error.statusText;
        }
        return {
          'message': message
        };
      }
      if (_typeof(error) === 'object') {
        if (error.message === 'Request aborted' || error.message === null || error.message === '' || error.message === 0 || error.message === '0') {
          console.error('aborted');
          return false;
        }
      } else {
        return error;
      }
    }
  }, {
    key: "appendHtml",
    value: function appendHtml(parent, html) {
      if (!parent) {
        return;
      }

      // Append new element
      var newElement = document.createElement('div');
      newElement.innerHTML = html;
      console.log(html);
      console.log(newElement.firstChild);
      parent.appendChild(newElement.firstChild);
    }
  }]);
  return ExtraProAjax;
}();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtraProAjax);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!*************************************************************!*\
  !*** ./plg_system_extrapro/es6/administrator/overrides.es6 ***!
  \*************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_ajax_es6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/ajax.es6 */ "./plg_system_extrapro/es6/util/ajax.es6");
/*
 * @package     ExtraPro Plugin
 * @subpackage  plg_system_extrapro
 * @version     1.0.0
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var ExtraProOverrides = /*#__PURE__*/function (_ExtraProAjax) {
  _inherits(ExtraProOverrides, _ExtraProAjax);
  var _super = _createSuper(ExtraProOverrides);
  function ExtraProOverrides() {
    var _this;
    _classCallCheck(this, ExtraProOverrides);
    _this = _super.call(this);
    _this.options = Joomla.getOptions('extrapro_overrides');
    _this.controller = _this.options && _this.options.controller ? _this.options.controller : false;
    return _this;
  }
  _createClass(ExtraProOverrides, [{
    key: "insertHTML",
    value: function insertHTML() {
      var tab = document.querySelector('#content joomla-tab#myTab joomla-tab-element#overrides');
      if (!tab || tab.getAttribute('extrapro-overrides-load') === 'true') {
        return;
      }
      var row = tab.querySelector('.row');
      if (!row) {
        return;
      }
      this.sendAjax('getOverridesHtml', {
        'extension_id': this.options.extension_id
      }).then(function (response) {
        if (!response) {
          return;
        }
        row.innerHTML += response;
        document.querySelectorAll('.folder-url, .component-folder-url, .plugin-folder-url, .layout-folder-url').forEach(function (element) {
          var clone = element.cloneNode(true);
          element.parentNode.replaceChild(clone, element);
        });
        tab.setAttribute('extrapro-overrides-load', 'true');
        Joomla.optionsStorage['joomla.messages'] = [];
        document.dispatchEvent(new Event('DOMContentLoaded', {
          'bubbles': true
        }));
      }).catch(function (error) {
        Joomla.renderMessages({
          error: [error.message]
        });
        console.error(error.message);
      });
    }
  }]);
  return ExtraProOverrides;
}(_util_ajax_es6__WEBPACK_IMPORTED_MODULE_0__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtraProOverrides);
window.ExtraProOverridesClass = null;
window.ExtraProOverrides = function () {
  if (window.ExtraProOverridesClass === null) window.ExtraProOverridesClass = new ExtraProOverrides();
  return window.ExtraProOverridesClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.ExtraProOverrides().insertHTML();
});
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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