/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./plg_system_extrapro/es6/util/ajax.es6":
/*!***********************************************!*\
  !*** ./plg_system_extrapro/es6/util/ajax.es6 ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/*
 * @package     ExtraPro Plugin
 * @subpackage  plg_system_extrapro
 * @version     1.0.0
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */



function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var ExtraProAjax = /*#__PURE__*/function () {
  function ExtraProAjax() {
    _classCallCheck(this, ExtraProAjax);
    this.options = null;
    this.controller = null;
  }
  _createClass(ExtraProAjax, [{
    key: "setVariable",
    value: function setVariable(key, value) {
      this[key] = value;
    }
  }, {
    key: "getVariable",
    value: function getVariable(key) {
      var defaultValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      return !this[key] || this[key] === null ? defaultValue : this[key];
    }
  }, {
    key: "sendAjax",
    value: function sendAjax() {
      var _this = this;
      var action = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return new Promise(function (success, error) {
        if (action === null) {
          return error({
            message: 'Action is empty'
          });
        }
        var controller = _this.controller;
        if (!controller) {
          return error({
            message: 'Controller not found'
          });
        }
        var isFormData = data instanceof FormData,
          formData = isFormData ? data : new FormData();
        if (!isFormData) {
          formData = _this.objectToFormData(data, formData);
        }
        formData.set('action', action);
        _this.sendRequest(controller, formData).then(function (s) {
          return success(s);
        }).catch(function (e) {
          return error(e);
        });
      });
    }
  }, {
    key: "objectToFormData",
    value: function objectToFormData() {
      var _this2 = this;
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var formData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
      if (formData === null) {
        formData = new FormData();
      }
      if (path === null) {
        path = '';
      }
      Object.keys(data).forEach(function (key) {
        var name = path ? path + '[' + key + ']' : key,
          value = data[key];
        if (Array.isArray(value)) {
          value.forEach(function (val) {
            formData.append(name + '[]', val);
          });
        } else if (_typeof(value) === 'object') {
          formData = _this2.objectToFormData(value, formData, name);
        } else {
          formData.set(name, value);
        }
      });
      return formData;
    }
  }, {
    key: "sendRequest",
    value: function sendRequest(controller, formData) {
      var _this3 = this;
      return new Promise(function (success, error) {
        Joomla.request({
          url: controller,
          data: formData,
          method: 'POST',
          onSuccess: function onSuccess(response) {
            try {
              response = JSON.parse(response);
              if (response.success) {
                return success(response.data);
              } else {
                return error({
                  message: response.message
                });
              }
            } catch (je) {
              return error(je);
            }
          },
          onError: function onError(e) {
            var errorObject = _this3.parseJoomlaRequestError(e);
            if (errorObject) {
              return error(errorObject);
            }
          }
        });
      });
    }
  }, {
    key: "parseJoomlaRequestError",
    value: function parseJoomlaRequestError(error) {
      if (error instanceof XMLHttpRequest) {
        if (error.status === 0) {
          console.error('aborted');
          return false;
        }
        var message;
        if (error.response) {
          var responseElement = document.createElement('div');
          responseElement.innerHTML = error.response;
          if (responseElement) {
            responseElement = responseElement.querySelector('title');
            if (responseElement) {
              message = responseElement.textContent;
            }
          }
        } else {
          message = error.status + ' ' + error.statusText;
        }
        return {
          'message': message
        };
      }
      if (_typeof(error) === 'object') {
        if (error.message === 'Request aborted' || error.message === null || error.message === '' || error.message === 0 || error.message === '0') {
          console.error('aborted');
          return false;
        }
      } else {
        return error;
      }
    }
  }, {
    key: "appendHtml",
    value: function appendHtml(parent, html) {
      if (!parent) {
        return;
      }

      // Append new element
      var newElement = document.createElement('div');
      newElement.innerHTML = html;
      console.log(html);
      console.log(newElement.firstChild);
      parent.appendChild(newElement.firstChild);
    }
  }]);
  return ExtraProAjax;
}();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtraProAjax);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!**************************************************!*\
  !*** ./plg_system_extrapro/es6/site/toolbar.es6 ***!
  \**************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _util_ajax_es6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../util/ajax.es6 */ "./plg_system_extrapro/es6/util/ajax.es6");
/*
 * @package     ExtraPro Plugin
 * @subpackage  plg_system_extrapro
 * @version     1.0.0
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */



/*
 * @package     ExtraPro Plugin
 * @subpackage  plg_system_extrapro
 * @version     1.0.0
 * @author      RadicalMart Team - radicalmart.ru
 * @copyright   Copyright (c) 2024 RadicalMart. All rights reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://radicalmart.ru/
 */

"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

var ExtraProToolbar = /*#__PURE__*/function (_ExtraProAjax) {
  _inherits(ExtraProToolbar, _ExtraProAjax);
  var _super = _createSuper(ExtraProToolbar);
  function ExtraProToolbar() {
    var _this;
    _classCallCheck(this, ExtraProToolbar);
    _this = _super.call(this);
    _this.options = Joomla.getOptions('extrapro_toolbar');
    _this.controller = _this.options && _this.options.controller ? _this.options.controller : false;
    return _this;
  }
  _createClass(ExtraProToolbar, [{
    key: "insertHTML",
    value: function insertHTML() {
      this.sendAjax('getToolbarHtml', {
        'style_id': this.options.style_id,
        'context': this.options.context,
        'return': window.location.href
      }).then(function (response) {
        if (!response) {
          return;
        }
        document.body.insertAdjacentHTML('beforeend', response);
      }).catch(function (error) {
        console.error(error.message);
      });
    }
  }]);
  return ExtraProToolbar;
}(_util_ajax_es6__WEBPACK_IMPORTED_MODULE_0__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExtraProToolbar);
window.ExtraProToolbarClass = null;
window.ExtraProToolbar = function () {
  if (window.ExtraProToolbarClass === null) window.ExtraProToolbarClass = new ExtraProToolbar();
  return window.ExtraProToolbarClass;
};
document.addEventListener('DOMContentLoaded', function () {
  window.ExtraProToolbar().insertHTML();
});
})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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