<?php
/*
 * @package    TelePost System Plugin
 * @version     1.0.0
 * @author      CaveDesign Studio - cavedesign.ru
 * @copyright   Copyright (c) 2025 CaveDesign Studio. All Rights Reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://cavedesign.ru/
 */

namespace Joomla\Plugin\System\Telepost\Field;

\defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\ListField;
use Joomla\CMS\Language\Text;
use Joomla\Plugin\System\Telepost\Helper\TelepostHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Registry\Registry;

/**
 * Form field for displaying a list of Telegram chats.
 *
 * @since  1.0.0
 */
class ChatlistField extends ListField
{
	/**
	 * The form field type.
	 * @var    string
	 * @since  1.0.0
	 */
	protected $type = 'Chatlist';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 *
	 * @since   1.0.0
	 */
	protected function getOptions(): array
	{
		$options = parent::getOptions();

		$chats = TelepostHelper::getRuntimeChats();

		if (empty($chats)) {
			$pluginParams = PluginHelper::getPlugin('system', 'telepost')->params ?? null;
			if ($pluginParams) {
				$registry = new Registry($pluginParams);
				$rawJson = $registry->get('saved_chats');
				$chats = json_decode($rawJson, true) ?? [];
			}
		}

		if (empty($chats))
		{
			$options[] = [
				'value' => '',
				'text' => Text::_('PLG_SYSTEM_TELEPOST_NO_CHATS_FOUND_INSTRUCTIONS'),
				'disabled' => true
			];
			return $options;
		}

		foreach ($chats as $id => $title)
		{
			$options[] = [
				'value' => $id,
				'text' => $title . " (ID: $id)"
			];
		}

		if (!empty($this->value) && !isset($chats[$this->value])) {
			$options[] = [
				'value' => $this->value,
				'text' => Text::_('PLG_SYSTEM_TELEPOST_CHAT_SAVED_VALUE') . ' ' . $this->value
			];
		}

		return $options;
	}
}