<?php
/*
 * @package    TelePost System Plugin
 * @version     1.0.0
 * @author      CaveDesign Studio - cavedesign.ru
 * @copyright   Copyright (c) 2025 CaveDesign Studio. All Rights Reserved.
 * @license     GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link        https://cavedesign.ru/
 */

namespace Joomla\Plugin\System\Telepost\Field;

\defined('_JEXEC') or die;

use Joomla\CMS\Form\Field\PasswordField;
use Joomla\CMS\Language\Text;

/**
 * Form field for a secret key with a generation button.
 *
 * @since  1.0.0
 */
class SecretkeyField extends PasswordField
{
	/**
	 * The form field type.
	 * @var    string
	 * @since  1.0.0
	 */
	protected $type = 'secretkey';

	/**
	 * Method to get the field input markup.
	 *
	 * @return  string
	 *
	 * @since   1.0.0
	 */
	protected function getInput(): string
	{
		$html = parent::getInput();

		$onclick = "
            const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
            let result = '';
            for (let i = 0; i < 32; i++) {
                result += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            document.getElementById('{$this->id}').value = result;
            return false;
        ";

		$button = '<button type="button" class="btn btn-secondary" 
		style="margin-left: 15px" onclick="' . htmlspecialchars($onclick) . '">'
			. '<span class="icon-loop" aria-hidden="true"></span> '
			. Text::_('PLG_SYSTEM_TELEPOST_GENERATE_KEY_BTN')
			. '</button>';

		return '<div class="input-group">' . $html . $button . '</div>';
	}
}