<?php

/**
 * @package   Revo Converter
 * @author    Alex Revo https://alexrevo.pw   
 * @copyright Copyright (C) Aleksandr Sudbinov
 * @license   Commerce
 */

defined('_JEXEC') or die;

class PlgSystemRevoconverterInstallerScript
{
    public function install($parent)
    {
        $this->enablePlugin();

        return true;
    }

    private function enablePlugin()
    {
        try {
            // Получаем экземпляр БД через современный API Joomla 5
            $db = \Joomla\CMS\Factory::getDbo();

            $query = $db->getQuery(true)
                ->update($db->quoteName('#__extensions'))
                ->set($db->quoteName('enabled') . ' = 1')
                ->where($db->quoteName('type') . ' = ' . $db->quote('plugin'))
                ->where($db->quoteName('element') . ' = ' . $db->quote('revoconverter'));

            $db->setQuery($query);
            $db->execute();
        } catch (\Exception $e) {
            // Логирование ошибки или вывод сообщения
            \Joomla\CMS\Factory::getApplication()->enqueueMessage('Error enabling plugin: ' . $e->getMessage(), 'error');
        }
    }
}
